#include <conio.h>
#include <dos.h>
#include <graph.h>
#include <afxcoll.h>
#include <colors.h>
#include <osw.h>
#include <designat.h>
#include <freqasg.h>
#include <trunksys.h>

Scanner::Scanner(double baudrate) : lp(0) {
		set8250(baudrate);     /* set up 8250 UART                    */ 
}
void
Scanner::topIs(frequencyAssignment* fp){
	if( fp != lp ) {
		if( lp ) {
			QuickOut(lp->y,lp->x+PRTYSTART-1,LIGHTGREEN," ");
		}
		if( fp && fp->scancmd[0]) {
			QuickOut(fp->y,fp->x+PRTYSTART-1,LIGHTGREEN,"*");
			putString(fp->scancmd);
		}
		lp = fp;
	}
}
AR8000::AR8000() : Scanner() {
		putString("DD\r"); // establish vfo operation
		putString("MD1\r"); // establish NFM mode
		putString("AT0\r"); // attenuator off
		putString("ST012500\r"); // step 12.5 no offset
		
}
void
AR8000::setFreqString(frequencyAssignment *f) {
	if( strstr(f->freqdisp,".") ) {
		f->scancmd[0] = 'R';		// R
		f->scancmd[1] = 'F';		// F
		f->scancmd[2] = '0';		// 0
		f->scancmd[3] = f->freqdisp[3];	// 8
		f->scancmd[4] = f->freqdisp[4];	// x
		f->scancmd[5] = f->freqdisp[5];	// x
		f->scancmd[6] = f->freqdisp[7];	// f
		f->scancmd[7] = f->freqdisp[8];	// f 
		f->scancmd[8] = f->freqdisp[9];	// f 
		f->scancmd[9] = f->freqdisp[10];	// f
		f->scancmd[10] = '0';            // 0
		f->scancmd[11] = '0';            // 0
		f->scancmd[12] = '\r';
		f->scancmd[13] = '\0';
	} else {
		f->scancmd[0] = 0; // unknown mapping
	}

}
AR3000::AR3000() : Scanner(4800.0)
{
	putString("12.5S");		// establish vfo operation
		
}
void
AR3000::setFreqString(frequencyAssignment *f) 
{
	if( strstr(f->freqdisp,".") ) {
		sprintf(f->scancmd,"%sN",&f->freqdisp[3]);
	} else {
		f->scancmd[0] = 0; // unknown mapping
	}
}
AR3000A::AR3000A() : Scanner()
{
	putString("12.5S");		// establish vfo operation
		
}
void
AR3000A::setFreqString(frequencyAssignment *f) 
{
	if( strstr(f->freqdisp,".") ) {
		sprintf(f->scancmd,"%sN\r",&f->freqdisp[3]);
	} else {
		f->scancmd[0] = 0; // unknown mapping
	}
}
AR2700::AR2700() : Scanner()
{
	putString("AU0\r"); // establish vfo operation
	putString("MD1\r"); // establish NFM mode
	putString("AT0\r"); // attenuator off
}
void
AR2700::setFreqString(frequencyAssignment *f)
{
	if( strstr(f->freqdisp,".") ) {
		f->scancmd[0] = 'R';			// R
		f->scancmd[1] = 'F';			// F
		f->scancmd[2] = '0';			// 0
		f->scancmd[3] = f->freqdisp[3];	// 8
		f->scancmd[4] = f->freqdisp[4];	// x
		f->scancmd[5] = f->freqdisp[5];	// x
		f->scancmd[6] = f->freqdisp[6]; // .
		f->scancmd[7] = f->freqdisp[7];	// f
		f->scancmd[8] = f->freqdisp[8];	// f 
		f->scancmd[9] = f->freqdisp[9];	// f 
		f->scancmd[10]= f->freqdisp[10];// f
		f->scancmd[11]= '0';	    	// 0
		f->scancmd[12] = '\r';
		f->scancmd[13] = '\0';
	} else {
		f->scancmd[0] = 0; // unknown mapping
	}
}

Kenwood::Kenwood(double baudrate) : Scanner(baudrate)
{
	putString("MD4;"); // establish NFM mode
}
void
Kenwood::setFreqString(frequencyAssignment *f)
{
	if( strstr(f->freqdisp,".") ) {
		f->scancmd[0] = 'F';			// F
		f->scancmd[1] = 'A';			// A
		f->scancmd[2] = '0';			// 0
		f->scancmd[3] = '0';			// 0
		f->scancmd[4] = f->freqdisp[3];	// 8
		f->scancmd[5] = f->freqdisp[4];	// x
		f->scancmd[6] = f->freqdisp[5];	// x
		f->scancmd[7] = f->freqdisp[7];	// f
		f->scancmd[8] = f->freqdisp[8];	// f 
		f->scancmd[9] = f->freqdisp[9];	// f 
		f->scancmd[10]= f->freqdisp[10];// f
		f->scancmd[11]= '0';	    	// 0
		f->scancmd[12]= '0';	    	// 0
		f->scancmd[13] = ';';			// ;
		f->scancmd[14] = '\0';
	} else {
		f->scancmd[0] = 0; // unknown mapping
	}
}
BC895::BC895() : Scanner()
{
		putString("KEY01\r"); // stop scanning
}
void
BC895::setFreqString(frequencyAssignment *f)
{
	if( strstr(f->freqdisp,".") ) {
		f->scancmd[0] = 'R';		// R
		f->scancmd[1] = 'F';		// F
		f->scancmd[2] = '0';		// 0
		f->scancmd[3] = f->freqdisp[3];	// 8
		f->scancmd[4] = f->freqdisp[4];	// x
		f->scancmd[5] = f->freqdisp[5];	// x
		f->scancmd[6] = f->freqdisp[7];	// f
		f->scancmd[7] = f->freqdisp[8];	// f 
		f->scancmd[8] = f->freqdisp[9];	// f 
		f->scancmd[9] = f->freqdisp[10];	// f
		f->scancmd[10] = '\r';
		f->scancmd[11] = '\0';
	} else {
		f->scancmd[0] = 0; // unknown mapping
	}
}
void
NOSCANNER::setFreqString(frequencyAssignment *f) {
			f->scancmd[0] = 0; // unknown mapping
}
