@ECHO OFF
REM -----------------------------------------------------------------------
REM          I20R harddrive installation routine   (3 1/2 in. disk)
REM -----------------------------------------------------------------------
REM
REM          This batch file installs the following files:
REM
REM          DISK#          FILE NAME             DESTINATION
REM         -------        -----------           -------------
REM         DISK 1         I20R.TAB             C:\I20R.BAT
REM         DISK 1         I20RA01.DAT           C:\MRSS\I20R\ARCHIVE\
REM         DISK 1         I20RB01.K01           C:\MRSS\I20R\ARCHIVE\
REM         DISK 1         I20R.EXE             C:\MRSS\I20R\
REM         ----------------------------------------------------


IF NOT "%1"=="" goto INSTALL
ECHO !!!!
ECHO !!!! No installation drive specified!
ECHO !!!! Please specify a drive.  Example hdinstall c
ECHO !!!!
goto ENDFAIL

:INSTALL
CLS
IF NOT EXIST %1\*.* GOTO HDDRVERR
GOTO INTRO
:LB_INT
GOTO CRTDIR
:LB_CRT

REM -----------------------------------------------------------------------
REM                Ensure DISK #1 is in Floppy Drive and Copy Files
REM -----------------------------------------------------------------------

IF EXIST I20RRSS.EXE GOTO IN_DSK1
GOTO DISK1
:LB_DSK1
IF EXIST I20RRSS.EXE GOTO IN_DSK1
GOTO DISK1
:LB_DSK1
IF EXIST I20RRSS.EXE GOTO IN_DSK1
GOTO DSK1_ERR

:IN_DSK1
CLS
ECHO    ͻ
ECHO                         I20R Radio Service Software                        
ECHO                        HARD DISK INSTALLATION PROCEDURE                    
ECHO    ͹
ECHO                                                                           
ECHO                                                                            
ECHO                                                                            
ECHO                  Copying the contents of DISK #1 to hard disk.             
ECHO                                                                            
ECHO                                                                           
ECHO         !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!    
ECHO         NOTE:  Use of double buffering with SMARTDRV (which is common in   
ECHO               certain computers), may cause the i20R Radio Service        
ECHO                Software and other software packages to become unstable.    
ECHO               Refer to your computer's manual for information on           
ECHO               disabling these double buffers.                              
ECHO        !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!    
ECHO                                                                           
ECHO    ĺ
ECHO         Press Ctrl-C, at any time, to ABORT the installation process.     
ECHO    ͼ
ECHO 
ECHO 
ECHO 
IF NOT EXIST %1\I20R.BAT COPY I20R.TAB %1\I20R.BAT /V >NUL
I20RRSS -o %1\MRSS\I20R >NUL
IF NOT EXIST %1\MRSS\I20R\ARCHIVE\I20R?01.* copy %1\MRSS\I20R\I20R?01.* %1\MRSS\I20R\ARCHIVE > NUL
GOTO ENDSUC


REM -----------------------------------------------------------------------
REM         INTRODUCTION SCREEN -- SHOULD MATCH BANNER SCREEN OF RSS
REM -----------------------------------------------------------------------

:INTRO
CLS
ECHO 
ECHO 
ECHO                                     HARD DISK
ECHO 
ECHO                                   INSTALLATION
ECHO 
ECHO 
ECHO 
ECHO 
ECHO 
ECHO 
ECHO 
ECHO 
ECHO 
ECHO 
ECHO 
ECHO                              RADIO SERVICE SOFTWARE
ECHO                                     for the
ECHO                                     I20R
ECHO 
ECHO             VERSION   R01.00.09                            14-FEB-96
ECHO 
ECHO     (C) Copyright Instrument Associates 1995-96            All Rights Reserved.
PAUSE
GOTO LB_INT

REM -----------------------------------------------------------------------
REM         VERIFY EXISTENCE AND/OR CREATE NECESSARY SUB-DIRECTORIES
REM -----------------------------------------------------------------------

:CRTDIR
CLS
ECHO    ͻ
ECHO                          I20R Radio Service Software                       
ECHO                        HARD DISK INSTALLATION PROCEDURE                    
ECHO    ͹
ECHO                                                                           
ECHO                                                                            
ECHO         The following SUB-DIRECTORIES will be created on your system:     
ECHO                                                                           
ECHO                             %1\MRSS                                        
ECHO                             %1\MRSS\I20R                                   
ECHO                             %1\MRSS\I20R\ARCHIVE                           
ECHO                                                                           
ECHO                                                                            
ECHO                                                                           
ECHO                                                                            
ECHO         A BATCH file, I20R.BAT, will be placed in the root directory       
ECHO        to enable the user to execute the program from %1\.                
ECHO                                                                           
ECHO    ĺ
ECHO         Press Ctrl-C, at any time, to ABORT the installation process.     
ECHO    ͼ
ECHO 
PAUSE
REM Confirm existence or create sub-directories
MD %1\MRSS > NUL
MD %1\MRSS\I20R > NUL
MD %1\MRSS\I20R\ARCHIVE  > NUL
CLS
ECHO    ͻ
ECHO                         I20R Radio Service Software                        
ECHO                        HARD DISK INSTALLATION PROCEDURE                    
ECHO    ͹
ECHO                                                                           
ECHO                                                                            
ECHO                         The following SUB-DIRECTORIES:                    
ECHO                                                                           
ECHO                             %1\MRSS                                        
ECHO                             %1\MRSS\I20R                                   
ECHO                             %1\MRSS\I20R\ARCHIVE                           
ECHO                                                                           
ECHO                                                                            
ECHO               ... have been verified/created on the hard disk.            
ECHO                                                                            
ECHO                                                                            
ECHO                                                                           
ECHO                                                                           
ECHO    ĺ
ECHO         Press Ctrl-C, at any time, to ABORT the installation process.     
ECHO    ͼ
ECHO 
PAUSE
GOTO LB_CRT

REM -----------------------------------------------------------------------
REM                          Begin DISK PROMPT Section
REM -----------------------------------------------------------------------

:DISK1
CLS
ECHO    ͻ
ECHO                         I20R Radio Service Software                        
ECHO                        HARD DISK INSTALLATION PROCEDURE                    
ECHO    ͹
ECHO                                                                            
ECHO                                                                           
ECHO                                                                           
ECHO                   Must change current drive to source drive.               
ECHO                                                                           
ECHO                                                                            
ECHO                                                                           
ECHO                                                                           
ECHO                                                                           
ECHO    ͼ
GOTO ENDFAIL

REM -----------------------------------------------------------------------
REM                             Begin ERROR Section
REM -----------------------------------------------------------------------

:HDDRVERR
CLS
ECHO    ͻ
ECHO                         I20R Radio Service Software                        
ECHO                  HARD DISK INSTALLATION PROCEDURE TERMINATED.              
ECHO    ͹
ECHO                                                                            
ECHO                                                                           
ECHO                                                                           
ECHO                     ERROR:  HARD DISK DRIVE %1 NOT FOUND                   
ECHO                                                                           
ECHO                       Please specify the correct drive.                    
ECHO                                                                           
ECHO                                                                           
ECHO                                                                           
ECHO    ͼ
GOTO ENDFAIL

:DSK1_ERR
CLS
ECHO    ͻ
ECHO                         I20R Radio Service Software                        
ECHO                  HARD DISK INSTALLATION PROCEDURE TERMINATED.              
ECHO    ͹
ECHO                                                                            
ECHO                                                                           
ECHO                                                                           
ECHO                       ERROR:  FILE NOT FOUND ON DISK #1.                   
ECHO                                                                           
ECHO                                                                            
ECHO                      INSTALLATION PROCESS IS TERMINATED.                  
ECHO                                                                           
ECHO                                                                           
ECHO    ͼ
GOTO ENDFAIL

:ENDSUC
CLS
ECHO    ͻ
ECHO                         I20R Radio Service Software                        
ECHO                        HARD DISK INSTALLATION PROCEDURE                    
ECHO    ͹
ECHO                                                                           
ECHO                                                                           
ECHO                       I20R Radio Service Software                         
ECHO                                                                            
ECHO            HARD DISK INSTALLATION PROCEDURE COMPLETED SUCCESSFULLY!        
ECHO                                                                            
ECHO                                                                            
ECHO         !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!    
ECHO         NOTE:  Use of double buffering with SMARTDRV (which is common in   
ECHO               certain computers), may cause the i20R Radio Service        
ECHO                Software and other software packages to become unstable.    
ECHO               Refer to your computer's manual for information on           
ECHO               disabling these double buffers.                              
ECHO        !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!    
ECHO                                                                           
ECHO    ĺ
ECHO                To start the program, type %1 {enter} and I20R             
ECHO    ͼ
PAUSE
ECHO ON

:ENDFAIL


