#include <stdio.h>
#include <string.h>
#include <conio.h>

FILE *infile;
FILE *outfile;
int chan, channel;
long RxLO, TxLO;
long Rx, Tx;
char Data [100];
int Line;
unsigned char eprom[0x800];




void main (void)

{
    int temp;
    long ltemp;
    unsigned char c;
    unsigned int address;

    printf ("Programmer for CQM5664S UHF Radio - Version 1.00\n");
    printf ("Peter Baston 8th Jan 1997\n\n");
    
    
    outfile = fopen ("STORNO.BIN","w+b");
    if (NULL == (infile = fopen ("STORNO.PRG", "r"))) {
	fclose (outfile);
	printf ("Error opening file: STORNO.PRG\n");
	exit (0);
    }
    
    for (temp=0; temp < 0x800; temp++) {
	eprom[temp] = 0xFF;
    }
    
    
    Line = 0;
    channel = 0;

    while (1) {
	fgets (Data, 95, infile);
	if (feof (infile)) {
	    break;
	}
	temp = sscanf (Data, "%d %ld %ld", &chan, &Rx, &Tx);
	if (temp != 3) {
	    printf ("Error reading line: %d\n", Line);
	    break;
	}
	
	if (chan == 100) {
	    RxLO = Rx;
	    TxLO = Tx;
	}
	else {
	    channel++;
	    printf ("Channel: %2d  Rx: %ld  Tx: %ld ", chan, Rx, Tx);
	    
	    if (chan > 99) {
		printf ("Channel Error !!\n");
		break;
	    }
	    
	    // GWM mod has thumbwheel LSB on A0-A3, MSB on A5-A8
	    
	    address = 0x200 + ((chan / 10) * 32) + (chan % 10);

	    ltemp = Rx + 214000;
	    ltemp -= RxLO;
	    if ((ltemp % 125) ||
	        (ltemp < 32000) ||
		(ltemp > 63875)) {
		printf ("Rx Frequency Error !!!\n");
		break;
	    }
	    c = (unsigned char) ((ltemp / 125) - 256);
	    eprom[address] = c;
	    printf ("%02X ", c);
	
	    ltemp = Tx - TxLO;
	    if ((ltemp % 125) ||
	        (ltemp < 32000) ||
		(ltemp > 63875)) {
		printf ("Tx Frequency Error !!!\n");
		break;
	    }
	    c = (unsigned char) ((ltemp / 125) - 256);
	    
	    // GWM mod has tx/rx bit on A4
	    
	    eprom[address + 0x10] = c;
	    printf ("%02X\n", c);	
	
	}

	Line++;
	
    }
    fclose (infile);
    fwrite (eprom, 0x800, 1, outfile);
    fclose (outfile);
    printf ("Processing Completed !\n");
    printf ("Channels Programmed: %d\n", channel);

}/* main */
